cseg	segment
	org 100h
	assume cs:cseg,ds:cseg
start	proc near
	call lfeed
	mov si,offset buff
	call parse
	cmp byte ptr [si],255
	jnz here
	mov ah,19h
	int 21h
	inc al
	mov ah,al
	mov al,0
	mov [si],ax
	mov byte ptr [si+2],255
here:	cmp byte ptr [si],0
	jnz other
	inc si
	mov dl,[si]
	inc si
	call space
	cmp ah,1
	jnz here2
	call pntdrv
	mov dx,offset errmess
	mov ah,9
	int 21h
	jmp here
here2:	mov dx,offset bytes
	mov ah,9
	int 21h
	jmp here
leave:	int 20h
other:	cmp byte ptr [si],2
	jnz badpar
	inc si
	cmp byte ptr [si],1
	jnz badpar
	inc si
	mov cl,1
	call upper
	cmp byte ptr [si],65
	jz other2
	cmp byte ptr [si],88
	jnz badpar
	jmp pauth
other2: inc si
	mov dl,1
othlp:	call space
	inc dl
	cmp ah,1
	jz here
	push dx
	push ax
	mov dx,offset bytes
	mov ah,9
	int 21h
	pop ax
	pop dx
	jmp othlp
badpar: cmp byte ptr [si],255
	jz leave
	mov dx,offset badmes
	mov ah,9
	int 21h
	jmp leave
pauth:	mov dx,offset author
	mov ah,9
	int 21h
	inc si
	jmp here

space:	push si
	push dx
	mov ah,36h
	push dx
	int 21h
	pop dx
	cmp ax,0ffffh
	jnz conts
	mov ah,1
	jmp lvspa
conts:	call pntdrv
	mul bx
	mul cx
	mov si,offset buffer
	call condw
	call ascdw
	mov byte ptr [si+10],'$'
	mov cx,9
	call zapzer
	mov dx,si
here3:	mov ah,9
	int 21h
	mov ah,0
lvspa:	pop dx
	pop si
	ret
lfeed:	mov dx,offset lfee
	mov ah,9
	int 21h
	ret
pntdrv: push dx
	push ax
	add dl,64
	mov [drive],dl
	mov dx,offset message
	mov ah,9
	int 21h
	pop ax
	pop dx
	ret
start	endp

;PARSE COMMAND LINE

;Places parsed list at DS:SI - format
; 0/#		     Drive number #
; 1/#/filespec.ext   Filename of length #
; 2/#/parameter      /parameter of length #
; 255		     End of list
;everthing but SI, BP, segment registers, and stack messed up

parse	proc near
	push si
	mov di,80h
	mov cl,[di]
	inc di
	cmp cl,0
	jnz paraaa
	jmp paraar
paraaa: mov al,[di]			;main loop - jump here to
	cmp al,32			;process new sections
	jnz paraab
	jmp paraal
paraab: cmp al,'/'    ;47
	jnz paraac
	jmp paraam
paraac: cmp al,64
	jle paraal
	mov bx,offset paraat		;either filename or drivespec
	mov [paraas],0
paraad: mov [bx],al			;main loop for moving characters
	inc bx				;to the temporary buffer with
	inc di				;either filename or drivespec
	dec cl
	jz paraaf
paraae: mov al,[di]
	inc di
	dec cl
	cmp al,32
	jnz paraah
paraaf: cmp byte ptr [paraas],1 	;end of current string by end of
	jz paraak			;buffer or delimeter
	mov byte ptr [si],1
	mov dx,bx
	sub dx,offset paraat
	inc si
	mov [si],dl
	inc si
	mov bx,offset paraat
paraag: mov al,[bx]			;loop for moving filespec to return
	mov [si],al			;buffer
	inc si
	inc bx
	dec dl
	jnz paraag
	cmp cl,0
	jz paraar
	jmp paraaa
paraah: cmp al,':'                      ;check to see if char is a colon
	jnz paraai
	mov [paraas],1			;set colon=last character
	jmp paraaj
paraai: mov [paraas],0			;set colon<>last character
paraaj: mov [bx],al			;put in buffer
	inc bx
	cmp cl,0
	jz paraaf
	jmp paraae
paraak: mov byte ptr [si],0		;end of buffer, drivespec found
	inc si
	dec bx
	dec bx
	mov al,[bx]
	and al,95
	sub al,64
	mov byte ptr [si],al
	inc si
	cmp cl,0
	jz paraar
	jmp paraaa
paraal: inc di				;ignore character
	dec cl
	jz paraar
	jmp paraaa
paraam: inc di				;/parameter found
	dec cl
	jz paraao
	mov bx,offset paraat
paraan: mov al,[di]			;loop for placing characters
	cmp al,32			;into the temporary buffer
	jz paraao
	cmp al,'/'
	jz paraao
	mov [bx],al
	inc di
	inc bx
	dec cl
	jnz paraan
paraao: mov byte ptr [si],2		;end of parameter
	inc si
	mov dx,bx
	sub dx,offset paraat
	mov [si],dl
	inc si
	cmp dl,0
	jz paraaq
	mov bx,offset paraat
paraap: mov al,[bx]			;move characters from temporary
	mov [si],al			;buffer
	inc si
	inc bx
	dec dl
	jnz paraap
paraaq: cmp cl,0			;jump back to normal routine
	jz paraar
	jmp paraaa
paraar: mov byte ptr [si],255		;end of buffer code
	pop si
	ret				;leave
paraas	db ?				;colon=last character?
paraat	db 128 dup(?)			;temporary storage area
parse	endp

;CONVERT STRING TO UPPERCASE

;Changes string at DS:SI of length CL to uppercase
;CX and flags messed up

upper	proc near
	cmp cl,0
	jz uppaac
	push si
	mov ch,0
uppaaa: cmp byte ptr [si],96
	jle uppaab
	cmp byte ptr [si],123
	jge uppaab
	and byte ptr [si],223
uppaab: inc si
	loop uppaaa
	pop si
uppaac: ret
upper	endp

;CONVERT WORD TO DECIMAL

;Takes a number in AX and places the ascii value at DS:SI
;AX, BX, CX, and flags are messed up

conw	proc near
	mov cx,5
	mov bx,10
	add si,4
conaaa: mov dx,0
	div bx
	mov [si],dl
	dec si
	loop conaaa
	inc si
	ret
conw	endp

;CONVERT DOUBLEWORD TO DECIMAL

;Handles numbers 0-655,350,000 - pass it others and it INT 0s
;Takes a number in DX-AX and places the ascii value at DS:SI
;AX, BX, CX, DX, and flags are messed up

condw	proc near
	mov bx,10000
	div bx
	push dx
	call conw
	add si,4
	pop ax
	mov dl,[si]
	push dx
	call conw
	pop dx
	mov [si],dl
	sub si,4
	ret
condw	endp

;CONVERT DECIMAL WORD TO ASCII

;Takes number at DS:SI and leaves it in ASCII
;CX and flags messed up

ascw	proc near
	mov cx,5
ascaaa: add byte ptr [si],48
	inc si
	loop ascaaa
	sub si,5
	ret
ascw	endp

;CONVERT DECIMAL DOUBLEWORD TO ASCII

;Takes number at DS:SI and leaves it in ASCII
;CX, DX, and flags messed up

ascdw	proc near
	call ascw
	add si,4
	mov dl,[si]
	call ascw
	mov [si],dl
	sub si,4
	ret
ascdw	endp

;ZAP LEADING ZEROS IN A STRING

;Zaps leading zeros in a string of length CX at address DS:SI
;Returns with SI pointing to first nonzero byte
;CX and flags messed up

zapzer	proc near
	cmp cx,0
	jz zapaaa
	cmp byte ptr [si],48
	jnz zapaaa
	mov byte ptr [si],32
	inc si
	loop zapzer
zapaaa: ret
zapzer	endp

buffer	db 10 dup(?)
buff	db 170 dup(?)
message db 'Drive '
drive	db ?,': $'
errmess db 'invalid',13,10,'$'
bytes	db 'bytes free',13,10,'$'
badmes	db 'Invalid parameter',13,10,'$'
lfee	db 13,10,'$'
author	db 13,10,'FREE Version 1.3 By Alan Bishop',13,10
	db 'Please send all comments/bugs to',13,10
	db 'CIS 72405,647',13,10,10,'$'
cseg	ends
	end start

;program by Alan Bishop - CIS 72405,647 Version 1.3
